from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer
from urlparse import parse_qs
import cgi
import pika
import sys, os
import json
from datetime import datetime
from io import BytesIO
from Backhaul import Backhaul
import logging_rpi
import BackhaulConfiguration
import time

class GP(BaseHTTPRequestHandler):

    def _set_headers(self):
        self.send_response(200)
        self.send_header('Content-type', 'application/json')
        self.end_headers()

    def do_HEAD(self):
        self._set_headers()

    def do_GET(self):
        self._set_headers()
        self.wfile.write("<html><body><h1>Get Request Received!</h1></body></html>")

    def do_POST(self):
        content_length = int(self.headers['Content-Length'])
        body = self.rfile.read(content_length)
        self.send_response(200)
        self.end_headers()
        response = BytesIO()
        response.write(b'This is POST request. ')
        msg = None
        if self.path == '/queueRabbitMQ':
            msg = self.add_to_queue(body, publicQueue)
        else:
            logging_rpi.log.error("backhaulServer:::Invalid Path:::{0} does not exist.".format(self.path))
            msg = 404
        self.wfile.write(msg)

    def add_to_queue(self, form, queueName):

        try:
            form = form.encode('utf-8')
            form = json.loads(form)
            if form['Topic'] is None or form['Data'] is None:
                logging_rpi.log.error("backhaulServer:::add_to_queue:::No topic or data field with the data given")
                return 400
            if backhaul.sendData(form['Topic'], json.dumps(form['Data'])):
                print("[x] QUEUED to publicQueue %r" % form)
                return 200
            else:
                logging_rpi.log.error("backhaulServer:::add_to_queue:::Backhaul.sendData returned an Error")
                return 400
        except Exception as e:
            logging_rpi.log.error("backhaulServer:::add_to_queue:::"+str(e))
            return 400

while True:
    try:
        BackhaulConfiguration.logProcess(os.getpid())
        port = BackhaulConfiguration.getRMQServerPort()
        publicQueue = 'publicQueue'
        backhaul = Backhaul("publicQueue")
        def run(server_class=HTTPServer, handler_class=GP, port=port):
            server_address = ('', port)
            httpd = server_class(server_address, handler_class)
            logging_rpi.log.info("backhaulServer:::Server Running:::Running at Port " + str(port))
            httpd.serve_forever()
        run()

    except Exception as e:
        print e
        print "Sleeping 30 seconds before retrying..."
        time.sleep(30)
        pass